<?php

function sort_nested_arrays($array, $args = ["votes" => "desc"])
{
   usort($array, function ($a, $b) use ($args) {
      $res = 0;

      $a = (object) $a;
      $b = (object) $b;

      foreach ($args as $k => $v) {
         if ($a->$k == $b->$k) {
            continue;
         }
         $res = $a->$k < $b->$k ? 1 : -1;
         if ($v == "desc") {
            $res = -$res;
         }
         break;
      }
      return $res;
   });
   return $array;
}

function array_sort_by_accesslevel($array)
{
   // сортировка по уровню доступа
   global $UserAccessLevel;
   $new_array = [];

   foreach ($array as $user) {
      if ($user->accesslevel < $UserAccessLevel) {
         array_push($new_array, $user);
      }
   }
   return $new_array;
}
